/*
** ###################################################################
**     This code is generated by the Device Initialization Tool.
**     It is overwritten during code generation.
**     USER MODIFICATION ARE PRESERVED ONLY INSIDE INTERRUPT SERVICE ROUTINES
**     OR EXPLICITLY MARKED SECTIONS
**
**     Project   : JoystickAdapter
**     Processor : MC9S08JS16LCWJ
**     Version   : Component 01.000, Driver 01.06, CPU db: 3.00.014
**     Datasheet : MC9S08JS16RM Rev. 4 4/2009
**     Date/Time : 16.11.2011, 04:38
**     Abstract  :
**         This module contains device initialization code 
**         for selected on-chip peripherals.
**     Contents  :
**         Function "MCU_init" initializes selected peripherals
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################
*/

/* MODULE MCUinit */

#include <MC9S08JS16.h>                /* I/O map for MC9S08JS16LCWJ */
#include "MCUinit.h"

/* User declarations and definitions */
/*   Code, declarations and definitions here will be preserved during code generation */
extern void USB_ISR(void);
extern volatile unsigned short g_tick;
#include <stdio.h>
/* End of user declarations and definitions */


/*
** ===================================================================
**     Method      :  MCU_init (component MC9S08JS16_20)
**
**     Description :
**         Device initialization code for selected peripherals.
** ===================================================================
*/
void MCU_init(void)
{
  /* ### MC9S08JS16_20 "Cpu" init code ... */
  /*  PE initialization code after reset */

  /* Common initialization of the write once registers */
  /* SOPT1: COPT=0,STOPE=0,BLMSS=0,BKGDPE=0,RSTPE=0 */
  SOPT1 = 16;                                      
  /* SPMSC1: LVWF=0,LVWACK=0,LVWIE=0,LVDRE=1,LVDSE=1,LVDE=0 */
  SPMSC1 = 24;                                      
  /* SPMSC2: LVDV=0,LVWV=0,PPDF=0,PPDACK=0,PPDC=0 */
  SPMSC2 = 0;                                      
  /*  System clock initialization */
  if (*(unsigned char*far)65455 != 255) { /* Test if the device trim value is stored on the specified address */
    MCGTRM = *(unsigned char*far)65455; /* Initialize MCGTRM register from a non volatile memory */
    MCGSC = *(unsigned char*far)65454; /* Initialize MCGSC register from a non volatile memory */
  }
  /* MCGC2: BDIV=0,RANGE=1,HGO=0,LP=0,EREFS=0,ERCLKEN=1,EREFSTEN=0 */
  MCGC2 = 34;                          /* Set MCGC2 register */
  /* MCGC1: CLKS=2,RDIV=7,IREFS=0,IRCLKEN=1,IREFSTEN=0 */
  MCGC1 = 186;                         /* Set MCGC1 register */
  while(MCGSC_IREFST) {                /* Wait until external reference is selected */
  }
  while((MCGSC & 12) != 8) {           /* Wait until external clock is selected as a bus clock reference */
  }
  /* MCGC2: BDIV=0,RANGE=1,HGO=0,LP=1,EREFS=0,ERCLKEN=1,EREFSTEN=0 */
  MCGC2 = 42;                          /* Set MCGC2 register */
  /* MCGC1: CLKS=2,RDIV=2,IREFS=0,IRCLKEN=1,IREFSTEN=0 */
  MCGC1 = 146;                         /* Set MCGC1 register */
  /* MCGC3: LOLIE=0,PLLS=1,CME=0,VDIV=6 */
  MCGC3 = 70;                          /* Set MCGC3 register */
  /* MCGC2: LP=0 */
  MCGC2 &= (unsigned char)~8;                     
  while(!MCGSC_PLLST) {                /* Wait until PLL is selected */
  }
  while(!MCGSC_LOCK) {                 /* Wait until PLL is locked */
  }
  /* MCGC1: CLKS=0,RDIV=2,IREFS=0,IRCLKEN=1,IREFSTEN=0 */
  MCGC1 = 18;                          /* Set MCGC1 register */
  while((MCGSC & 12) != 12) {          /* Wait until PLL clock is selected as a bus clock reference */
  }
  
  /* Common initialization of the CPU registers */
  /* PTASE: PTASE7=0,PTASE6=0,PTASE5=0,PTASE4=0,PTASE3=0,PTASE2=0,PTASE1=0,PTASE0=0 */
  PTASE = 0;                                      
  /* PTBSE: PTBSE5=0,PTBSE4=0,PTBSE3=0,PTBSE2=0,PTBSE1=0 */
  PTBSE &= (unsigned char)~62;                     
  /* PTADS: PTADS7=0,PTADS6=0,PTADS5=0,PTADS4=0,PTADS3=0,PTADS2=0,PTADS1=0,PTADS0=0 */
  PTADS = 0;                                      
  /* PTBDS: PTBDS5=0,PTBDS4=1,PTBDS3=0,PTBDS2=0,PTBDS1=0 */
  PTBDS = 16;                                      
  /* ### Init_GPIO init code */
  /* PTBD: PTBD4=1,PTBD2=0,PTBD1=0,PTBD0=0 */
  PTBD = (PTBD & (unsigned char)~7) | (unsigned char)16;
  /* PTBPE: PTBPE4=1,PTBPE1=0,PTBPE0=1 */
  PTBPE = (PTBPE & (unsigned char)~2) | (unsigned char)17;
  /* PTBDD: PTBDD4=1,PTBDD1=1,PTBDD0=1 */
  PTBDD |= (unsigned char)19;                      
  /* ### Init_RTC init code */
  /* RTCMOD: RTCMOD=3 */
  RTCMOD = 3;                          /* Set modulo register */
  /* RTCSC: RTIF=1,RTCLKS=1,RTIE=1,RTCPS=9 */
  RTCSC = 185;                         /* Configure RTC */
  /* ### Init_USB init code */
  /* EPCTL0: EPCTLDIS=0,EPRXEN=0,EPTXEN=0,EPSTALL=0,EPHSHK=0 */
  EPCTL0 = 0;                                      
  /* EPCTL1: EPCTLDIS=0,EPRXEN=0,EPTXEN=0,EPSTALL=0,EPHSHK=0 */
  EPCTL1 = 0;                                      
  /* EPCTL2: EPCTLDIS=0,EPRXEN=0,EPTXEN=0,EPSTALL=0,EPHSHK=0 */
  EPCTL2 = 0;                                      
  /* EPCTL3: EPCTLDIS=0,EPRXEN=0,EPTXEN=0,EPSTALL=0,EPHSHK=0 */
  EPCTL3 = 0;                                      
  /* EPCTL4: EPCTLDIS=0,EPRXEN=0,EPTXEN=0,EPSTALL=0,EPHSHK=0 */
  EPCTL4 = 0;                                      
  /* EPCTL5: EPCTLDIS=0,EPRXEN=0,EPTXEN=0,EPSTALL=0,EPHSHK=0 */
  EPCTL5 = 0;                                      
  /* EPCTL6: EPCTLDIS=0,EPRXEN=0,EPTXEN=0,EPSTALL=0,EPHSHK=0 */
  EPCTL6 = 0;                                      
  /* ERRENB: BTSERR=0,BUFERR=0,BTOERR=0,DFN8=0,CRC16=0,CRC5=0,PIDERR=0 */
  ERRENB = 0;                                      
  /* INTENB: STALL=0,RESUME=0,SLEEP=0,TOKDNE=0,SOFTOK=0,ERROR=0,USBRST=0 */
  INTENB = 0;                                      
  /* USBCTL0: USBRESET=0,USBPU=0,USBRESMEN=0,LPRESF=0,USBVREN=0,USBPHYEN=0 */
  USBCTL0 = 0;                                      
  /* CTL: TSUSPEND=0,CRESUME=0,ODDRST=0,USBEN=1 */
  CTL = 1;                                      
  /* ### Init_SCI init code */
  /* SCIC2: TIE=0,TCIE=0,RIE=0,ILIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  SCIC2 = 0;                           /* Disable the SCI module */
  (void)(SCIS1 == 0);                  /* Dummy read of the SCIS1 register to clear flags */
  (void)(SCID == 0);                   /* Dummy read of the SCID register to clear flags */
  /* SCIS2: LBKDIF=1,RXEDGIF=1,RXINV=0,RWUID=0,BRK13=0,LBKDE=0,RAF=0 */
  SCIS2 = 192;                                      
  /* SCIBDH: LBKDIE=0,RXEDGIE=0,SBR12=0,SBR11=0,SBR10=0,SBR9=0,SBR8=0 */
  SCIBDH = 0;                                      
  /* SCIBDL: SBR7=0,SBR6=0,SBR5=0,SBR4=0,SBR3=1,SBR2=1,SBR1=0,SBR0=1 */
  SCIBDL = 13;                                      
  /* SCIC1: LOOPS=0,SCISWAI=0,RSRC=0,M=0,WAKE=0,ILT=0,PE=0,PT=0 */
  SCIC1 = 0;                                      
  /* SCIC3: R8=0,T8=0,TXDIR=1,TXINV=0,ORIE=0,NEIE=0,FEIE=0,PEIE=0 */
  SCIC3 = 32;                                      
  /* SCIC2: TIE=0,TCIE=0,RIE=0,ILIE=0,TE=1,RE=0,RWU=0,SBK=0 */
  SCIC2 = 8;                                      
  /* ### Init_GPIO init code */
  /* PTAD: PTAD5=1,PTAD4=0,PTAD2=0,PTAD1=0 */
  PTAD = (PTAD & (unsigned char)~22) | (unsigned char)32;
  /* PTAPE: PTAPE5=1,PTAPE4=0,PTAPE3=0,PTAPE2=0,PTAPE1=0 */
  PTAPE = (PTAPE & (unsigned char)~30) | (unsigned char)32;
  /* PTADD: PTADD5=1,PTADD4=1,PTADD3=1,PTADD2=1,PTADD1=0 */
  PTADD = (PTADD & (unsigned char)~2) | (unsigned char)60;
  /* ### Init_KBI init code */
  /* KBISC: KBIE=0 */
  KBISC &= (unsigned char)~2;                     
  /* KBIES: KBEDG7=0,KBEDG6=0,KBEDG5=0,KBEDG4=0,KBEDG3=0,KBEDG2=0,KBEDG1=0,KBEDG0=0 */
  KBIES = 0;                                      
  /* KBISC: KBMOD=0 */
  KBISC &= (unsigned char)~1;                     
  /* KBIPE: KBIPE7=0,KBIPE6=0,KBIPE5=0,KBIPE4=0,KBIPE3=0,KBIPE2=0,KBIPE1=0,KBIPE0=1 */
  KBIPE = 1;                                      
  /* KBISC: KBACK=1 */
  KBISC |= (unsigned char)4;                      
  /* KBISC: KBIE=1 */
  KBISC |= (unsigned char)2;                      
  /* ### */
  asm CLI;                             /* Enable interrupts */
} /*MCU_init*/


/*
** ===================================================================
**     Interrupt handler : isrVrtc
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVrtc(void)
{
  static int test = 0;
  /* Write your interrupt code here ... */
  RTCSC_RTIF = 1;
  g_tick++;
}
/* end of isrVrtc */


/*
** ===================================================================
**     Interrupt handler : isrVkeyboard
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVkeyboard(void)
{
  /* Write your interrupt code here ... */
  KBISC_KBACK = 1;
  printf("kb irq\r\n");

}
/* end of isrVkeyboard */


/*
** ===================================================================
**     Interrupt handler : isrVscitx
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVscitx(void)
{
  /* Write your interrupt code here ... */

}
/* end of isrVscitx */


/*
** ===================================================================
**     Interrupt handler : isrVscirx
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVscirx(void)
{
  /* Write your interrupt code here ... */

}
/* end of isrVscirx */


/*
** ===================================================================
**     Interrupt handler : isrVscierr
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVscierr(void)
{
  /* Write your interrupt code here ... */

}
/* end of isrVscierr */


/*
** ===================================================================
**     Interrupt handler : isrVusb
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVusb(void)
{
  /* Write your interrupt code here ... */
  USB_ISR();
}
/* end of isrVusb */



/* Initialization of the CPU registers in FLASH */

/* CHECKSUMBYPASS: BIT=0 */
const unsigned char CHECKSUMBYPASS_INIT @0x0000FFBA = 0;

/* NVPROT: FPS7=1,FPS6=1,FPS5=1,FPS4=1,FPS3=1,FPS2=1,FPS1=1,FPDIS=1 */
const unsigned char NVPROT_INIT @0x0000FFBD = 255;

/* NVOPT: KEYEN=0,FNORED=1,SEC01=1,SEC00=0 */
const unsigned char NVOPT_INIT @0x0000FFBF = 126;



extern near void _Startup(void);

/* Interrupt vector table */
#ifndef UNASSIGNED_ISR
  #define UNASSIGNED_ISR ((void(*near const)(void)) 0xFFFF) /* unassigned interrupt service routine */
#endif

void (* near const _vect[])(void) @0xFFC4 = { /* Interrupt vector table */
         isrVrtc,                      /* Int.no. 29 Vrtc (at FFC4)                  Used */
         UNASSIGNED_ISR,               /* Int.no. 28 VReserved28 (at FFC6)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 27 VReserved27 (at FFC8)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 26 Vmtim (at FFCA)                 Unassigned */
         isrVkeyboard,                 /* Int.no. 25 Vkeyboard (at FFCC)             Used */
         UNASSIGNED_ISR,               /* Int.no. 24 VReserved24 (at FFCE)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 23 VReserved23 (at FFD0)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 22 VReserved22 (at FFD2)           Unassigned */
         isrVscitx,                    /* Int.no. 21 Vscitx (at FFD4)                Used */
         isrVscirx,                    /* Int.no. 20 Vscirx (at FFD6)                Used */
         isrVscierr,                   /* Int.no. 19 Vscierr (at FFD8)               Used */
         UNASSIGNED_ISR,               /* Int.no. 18 VReserved18 (at FFDA)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 17 VReserved17 (at FFDC)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 16 VReserved16 (at FFDE)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 15 VReserved15 (at FFE0)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 14 VReserved14 (at FFE2)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 13 VReserved13 (at FFE4)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 12 VReserved12 (at FFE6)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 11 Vtpmovf (at FFE8)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 10 Vtpmch1 (at FFEA)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  9 Vtpmch0 (at FFEC)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  8 VReserved8 (at FFEE)            Unassigned */
         isrVusb,                      /* Int.no.  7 Vusb (at FFF0)                  Used */
         UNASSIGNED_ISR,               /* Int.no.  6 VReserved6 (at FFF2)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  5 Vspi (at FFF4)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  4 Vlol (at FFF6)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  3 Vlvd (at FFF8)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  2 Virq (at FFFA)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  1 Vswi (at FFFC)                  Unassigned */
         _Startup                      /* Int.no.  0 Vreset (at FFFE)                Reset vector */
};




/* END MCUinit */

/*
** ###################################################################
**
**     This file was created by Processor Expert 3.07 [04.34]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
