#include <hidef.h> /* for EnableInterrupts macro */
#include <stdio.h>
#include "derivative.h" /* include peripheral declarations */
#include "hardware.h"

unsigned short g_tick = 0;

void setCS(uint8_t state)
{
	if (state) PTAD_PTAD4 = 1; else PTAD_PTAD4 = 0;
}

void setSDI(uint8_t state)
{
	if (state) PTAD_PTAD2 = 1; else PTAD_PTAD2 = 0;
}

uint8_t isSDO()
{
  return PTAD_PTAD1;
}

void setSCK(uint8_t state)
{
	if (state) PTAD_PTAD3 = 1; else PTAD_PTAD3 = 0;
}

void setReset(uint8_t state)
{
	if (state) PTBD_PTBD2 = 1; else PTBD_PTBD2 = 0;
}

uint8_t spiTransfer(uint8_t data)
{
	uint8_t result = 0;
	uint8_t i;
	for (i = 0; i < 8; i++) {
		setSCK(0);
		if (data & 0x80) {
			setSDI(1);
		} else {
			setSDI(0);
		}
		setSCK(1);
		result <<= 1;
		result |= isSDO();
		data <<= 1;
	}
	setSCK(0);
	setSDI(0);
	return result;
}

void delayMs(uint16_t ms) {
  g_tick = 0;
  for (;;) {
    if (g_tick == ms) break;
  }
}

