#include <hidef.h> /* for EnableInterrupts macro */
#include <stdio.h>
#include "main.h"
#include "derivative.h" /* include peripheral declarations */
#include "keyboard.h"
#include "rfmodule.h"
#include "hardware.h"
#include "i2c.h"

extern void TestApp_Init(void);
extern void TestApp_Task(void);

#ifdef __cplusplus
 extern "C"
#endif
void MCU_init(void); /* Device initialization function declaration */


void TERMIO_PutChar(char c) {
    while (SCIS1_TDRE == 0) { }
    SCID = c;
}

typedef struct {
  uint16_t gpioOutput;
} MasterData;

typedef struct {
  int16_t temperature;
  int16_t x;
  int16_t y;
  int16_t z;
  uint16_t gpioInput;
} SlaveData;

MasterData g_masterData;
SlaveData g_slaveData;
uint8_t g_dataRequest;

void onUsbDataReceive(void* data)
{
  g_masterData = *((MasterData*) data);
  g_dataRequest = 1;
}

void onUsbDataRequest(void* data)
{
  *((SlaveData*) data) = g_slaveData;
}

void main(void)
{
  uint8_t deviceAddress;
  uint8_t i = 0;
  int16_t x = 0;
  int16_t y = 0;
  int16_t z = 0;
  memset(&g_masterData, 0, sizeof(MasterData));;
  memset(&g_slaveData, 0, sizeof(SlaveData));;
  g_masterData.gpioOutput = 0;
  MCU_init(); /* call Device Initialization */
  //set_printf(putChar);

  /* include your code here */
  i2cInit();
  //i2cTest();
  deviceAddress = (i2cGpioGet() & 0x3) ^ 3;
  printf("device address: %i\r\n", deviceAddress);
  if (deviceAddress == 0) {
    TestApp_Init();
  }
  rfInit();
  for (;;) {
    if (deviceAddress == 0) {
      TestApp_Task();
      // master, send request
      i = 0;
      if (g_dataRequest) {
        rfSendData(&g_masterData, sizeof(MasterData));
        g_dataRequest = 0;
      }

      // read response
      i = rfGetPacketLength();
      if (i == sizeof(SlaveData)) {
        rfGetData(&g_slaveData, sizeof(SlaveData));
//        printf("temperature: %i, x: %i, y: %i, z: %i %08x\r\n", g_slaveData.temperature, g_slaveData.x, g_slaveData.y, g_slaveData.z, g_slaveData.gpioInput);
      }
    } else {
      // slave, wait for master request
      i = rfGetPacketLength();
      if (i == sizeof(MasterData)) {
        // evaluate request
        rfGetData(&g_masterData, sizeof(MasterData));
        i2cGpioSet(g_masterData.gpioOutput);
      
        // send response
        g_slaveData.temperature = i2cReadTemperature();
        g_slaveData.x = i2cReadAccelX();
        g_slaveData.y = i2cReadAccelY();
        g_slaveData.z = i2cReadAccelZ();
        g_slaveData.gpioInput = i2cGpioGet();
        //printf("temperature: %i, x: %i, y: %i, z: %i %08x\r\n", g_slaveData.temperature, g_slaveData.x, g_slaveData.y, g_slaveData.z, g_slaveData.gpioInput);
        rfSendData(&g_slaveData, sizeof(SlaveData));
      }
    }
  }
}
