#include <windows.h>
#include <QThread>
#include <QtGui/QApplication>
#include <windows.h>
#include <conio.h>
#include <stdio.h>
#include <cmath>
#include <time.h>
#include "hid.h"
#include "mainwindow.h"
#include "QDebug"

#define VENDOR_ID 0x3EB
#define PRODUCT_ID 0x2013

unsigned char sequenceByte = 0;

HidDevice* device;

QMutex mutex;

SlaveData slaveData;
uint16_t gpio = 0x80;

void endianSwap(uint16_t& value)
{
        int low = value & 0xff;
        int high = (value >> 8) & 0xff;
        value = (low << 8) | high;
}

void endianSwap(int16_t& value)
{
        int low = value & 0xff;
        int high = (value >> 8) & 0xff;
        value = (low << 8) | high;
}

void ReadThread::run()
{
    int c = 0;
    while (true) {
        //Sleep(20);
        //qDebug() << c++ << "read" << endl;
        unsigned char message[64];
        device->readMessage(message, 64);
        QMutexLocker lock(&mutex);
        SlaveData* slaveDat = (SlaveData*) &message;
        endianSwap(slaveDat->temperature);
        endianSwap(slaveDat->x);
        endianSwap(slaveDat->y);
        endianSwap(slaveDat->z);
        endianSwap(slaveDat->gpioInput);
        slaveData = *slaveDat;
    }
}

void WriteThread::run()
{
    int c = 0;
    while (true) {
        //qDebug() << c++ << "write" << endl;
        unsigned char message[64];
        {
            QMutexLocker lock(&mutex);
            message[0] = gpio & 0xff;
            message[1] = (gpio >> 8) & 0xff;
        }
        device->sendMessage(message, 64);
        Sleep(50);
    }
}

int main(int argc, char** argv)
{
    qDebug() << "starting application" << endl;
    vector<HidDevice> devices = HidDevice::searchDevice(VENDOR_ID, PRODUCT_ID);
        if (devices.size() == 0) {
                qDebug() << "No I2C-Test hardware found" << endl;
                return -1;
        }
        device = &devices[0];

        qDebug() << "starting threads..." << endl;
        (new ReadThread())->start();
        (new WriteThread())->start();

        qDebug() << "creating windows..." << endl;
        QApplication a(argc, argv);
        MainWindow w;
        w.show();

        return a.exec();
}
