#include <QTimer>
#include "mainwindow.h"
#include "ui_mainwindow.h"

float angleX = 0;
float angleY = 0;
float angleZ = 0;

static GLfloat red[4] =
{0.8, 0.1, 0.0, 1.0};
static GLfloat green[4] =
{0.0, 0.8, 0.2, 1.0};
static GLfloat blue[4] =
{0.2, 0.2, 1.0, 1.0};

static GLfloat view_rotx = 0.0, view_roty = 0.0, view_rotz = 0.0;

MyGLDrawer::MyGLDrawer(QWidget *parent)
    : QGLWidget(parent)
{
    setGeometry(0, 0, parent->width(), parent->height());
}

void MyGLDrawer::initializeGL()
{
    m_quadratic = gluNewQuadric();
    gluQuadricNormals(m_quadratic, GLU_SMOOTH);
    gluQuadricDrawStyle( m_quadratic, GLU_FILL );
//    gluQuadricTexture(quadratic, GL_TRUE);


    static GLfloat pos[4] =
    {5.0, 5.0, 10.0, 0.0};
    glLightfv(GL_LIGHT0, GL_POSITION, pos);
    glEnable(GL_CULL_FACE);
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glEnable(GL_DEPTH_TEST);

    glEnable(GL_NORMALIZE);

    glShadeModel(GL_SMOOTH);

    glNormal3f(0.0, 0.0, 1.0);
}

void MyGLDrawer::resizeGL(int width, int height)
{
    GLfloat h = (GLfloat) height / (GLfloat) width;

    glViewport(0, 0, (GLint) width, (GLint) height);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glFrustum(-1.0, 1.0, -h, h, 5.0, 60.0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glTranslatef(0.0, 0.0, -40.0);
}

void renderCylinder(float x1, float y1, float z1, float x2,float y2, float z2, float r1, float r2, int subdivisions,GLUquadricObj *quadric)
{
    float vx = x2-x1;
    float vy = y2-y1;
    float vz = z2-z1;

    //handle the degenerate case of z1 == z2 with an approximation
    if(vz == 0)
        vz = .0001;

    float v = sqrt( vx*vx + vy*vy + vz*vz );
    float ax = 57.2957795*acos( vz/v );
    if ( vz < 0.0 )
        ax = -ax;
    float rx = -vy*vz;
    float ry = vx*vz;
    glPushMatrix();

    //draw the cylinder body
    glTranslatef( x1,y1,z1 );
    glRotatef(ax, rx, ry, 0.0);
    gluQuadricOrientation(quadric,GLU_OUTSIDE);
    gluCylinder(quadric, r1, r2, v, subdivisions, 1);

    //draw the first cap
    gluQuadricOrientation(quadric,GLU_INSIDE);
    gluDisk( quadric, 0.0, r1, subdivisions, 1);
    glTranslatef( 0,0,v );

    //draw the second cap
    if (r2 != 0.0f) {
        gluQuadricOrientation(quadric,GLU_OUTSIDE);
        gluDisk( quadric, 0.0, r2, subdivisions, 1);
    }

    glPopMatrix();
}

void MyGLDrawer::paintGL()
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glLoadIdentity();  /* reset modelview  */

    //glRotatef(45.0, 1.0, 1.0, 0.0);
    glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, green);
    glTranslatef(0.0, 0.0, -10.0);
    glRotatef(view_rotx, 1.0, 0.0, 0.0);
    glRotatef(view_roty, 0.0, 1.0, 0.0);
    glRotatef(view_rotz, 0.0, 0.0, 1.0);
    float radius = 0.5f;
    float rc = 0.2f;
    renderCylinder(0, 0, 0, 0, 0, 1.0f, radius, 0, 16, m_quadratic);
    renderCylinder(0, 0, -1.0f, 0, 0, 0.1f, rc, rc, 16, m_quadratic);
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    m_myGLDrawer = new MyGLDrawer(ui->frame);
    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(update()));
    timer->start(100);
    m_counter = 0;
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::update()
{
    QMutexLocker locker(&mutex);
    view_rotx = 270 - atan2f(slaveData.x, slaveData.z) * 45;
    view_roty = -atan2f(slaveData.y, slaveData.z) * 45;
    ui->temperatureLineEdit->setText(QString::number(float(slaveData.temperature) / 10.0f, 'f', 1) + "C");
    ui->xLineEdit->setText(QString::number(slaveData.x));
    ui->yLineEdit->setText(QString::number(slaveData.y));
    ui->zLineEdit->setText(QString::number(slaveData.z));
    gpio = ui->ledCheckBox->isChecked() ? 0x80 : 0x00;
    ui->buttonCheckBox->setChecked((slaveData.gpioInput & 0x80) == 0);
    m_myGLDrawer->updateGL();
}
