#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <windows.h>
#include <QtOpenGL>
#include <QThread>
#include <QMutex>
#include <QMainWindow>

#define uint8_t UINT8
#define int8_t INT8
#define uint16_t UINT16
#define int16_t INT16

namespace Ui {
    class MainWindow;
}

class MyGLDrawer : public QGLWidget
 {
     Q_OBJECT        // must include this if you use Qt signals/slots

 public:
     MyGLDrawer(QWidget *parent);

 protected:

     void initializeGL();

     void resizeGL(int w, int h);

     void paintGL();

private:
     GLUquadricObj* m_quadratic;
 };

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    void update();

private:
    Ui::MainWindow *ui;
    int m_counter;
    MyGLDrawer* m_myGLDrawer;
};




class ReadThread : public QThread
{
    Q_OBJECT
private:
    void run();
};

class WriteThread : public QThread
{
    Q_OBJECT
private:
    void run();
};

typedef struct {
  int16_t temperature;
  int16_t x;
  int16_t y;
  int16_t z;
  uint16_t gpioInput;
} SlaveData;

extern SlaveData slaveData;
extern uint16_t gpio;

extern QMutex mutex;

#endif // MAINWINDOW_H
