/*
** ###################################################################
**     This code is generated by the Device Initialization Tool.
**     It is overwritten during code generation.
**     USER MODIFICATION ARE PRESERVED ONLY INSIDE INTERRUPT SERVICE ROUTINES
**     OR EXPLICITLY MARKED SECTIONS
**
**     Project   : JoystickAdapter
**     Processor : MC9S08JS16LCWJ
**     Version   : Component 01.000, Driver 01.06, CPU db: 3.00.014
**     Datasheet : MC9S08JS16RM Rev. 4 4/2009
**     Date/Time : 23.07.2011, 16:14
**     Abstract  :
**         This module contains device initialization code 
**         for selected on-chip peripherals.
**     Contents  :
**         Function "MCU_init" initializes selected peripherals
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################
*/

/* MODULE MCUinit */

#include <MC9S08JS16.h>                /* I/O map for MC9S08JS16LCWJ */
#include "MCUinit.h"

/* User declarations and definitions */
/*   Code, declarations and definitions here will be preserved during code generation */
/* End of user declarations and definitions */


/*
** ===================================================================
**     Method      :  MCU_init (component MC9S08JS16_20)
**
**     Description :
**         Device initialization code for selected peripherals.
** ===================================================================
*/
void MCU_init(void)
{
  /* ### MC9S08JS16_20 "Cpu" init code ... */
  /*  PE initialization code after reset */

  /* Common initialization of the write once registers */
  /* SOPT1: COPT=0,STOPE=0,BLMSS=0,BKGDPE=0,RSTPE=0 */
  SOPT1 = 0x10;                                      
  /* SPMSC1: LVWF=0,LVWACK=0,LVWIE=0,LVDRE=1,LVDSE=1,LVDE=0 */
  SPMSC1 = 0x18;                                      
  /* SPMSC2: LVDV=0,LVWV=0,PPDF=0,PPDACK=0,PPDC=0 */
  SPMSC2 = 0x00;                                      
  /*  System clock initialization */
  if (*(unsigned char*far)0xFFAF != 0xFF) { /* Test if the device trim value is stored on the specified address */
    MCGTRM = *(unsigned char*far)0xFFAF; /* Initialize MCGTRM register from a non volatile memory */
    MCGSC = *(unsigned char*far)0xFFAE; /* Initialize MCGSC register from a non volatile memory */
  }
  /* MCGC2: BDIV=0,RANGE=1,HGO=0,LP=0,EREFS=0,ERCLKEN=1,EREFSTEN=0 */
  MCGC2 = 0x22;                        /* Set MCGC2 register */
  /* MCGC1: CLKS=2,RDIV=7,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
  MCGC1 = 0xB8;                        /* Set MCGC1 register */
  while(MCGSC_IREFST) {                /* Wait until external reference is selected */
  }
  while((MCGSC & 0x0C) != 0x08) {      /* Wait until external clock is selected as a bus clock reference */
  }
  /* MCGC2: BDIV=0,RANGE=1,HGO=0,LP=1,EREFS=0,ERCLKEN=1,EREFSTEN=0 */
  MCGC2 = 0x2A;                        /* Set MCGC2 register */
  /* MCGC1: CLKS=2,RDIV=2,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
  MCGC1 = 0x90;                        /* Set MCGC1 register */
  /* MCGC3: LOLIE=0,PLLS=1,CME=0,VDIV=6 */
  MCGC3 = 0x46;                        /* Set MCGC3 register */
  /* MCGC2: LP=0 */
  MCGC2 &= (unsigned char)~0x08;                     
  while(!MCGSC_PLLST) {                /* Wait until PLL is selected */
  }
  while(!MCGSC_LOCK) {                 /* Wait until PLL is locked */
  }
  /* MCGC1: CLKS=0,RDIV=2,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
  MCGC1 = 0x10;                        /* Set MCGC1 register */
  while((MCGSC & 0x0C) != 0x0C) {      /* Wait until PLL clock is selected as a bus clock reference */
  }
  
  /* Common initialization of the CPU registers */
  /* PTASE: PTASE7=0,PTASE6=0,PTASE5=0,PTASE4=0,PTASE3=0,PTASE2=0,PTASE1=0,PTASE0=0 */
  PTASE = 0x00;                                      
  /* PTBSE: PTBSE5=0,PTBSE4=0,PTBSE3=0,PTBSE2=0,PTBSE1=0 */
  PTBSE &= (unsigned char)~0x3E;                     
  /* PTADS: PTADS7=0,PTADS6=0,PTADS5=0,PTADS4=0,PTADS3=0,PTADS2=0,PTADS1=0,PTADS0=0 */
  PTADS = 0x00;                                      
  /* PTBDS: PTBDS5=0,PTBDS4=1,PTBDS3=0,PTBDS2=0,PTBDS1=0 */
  PTBDS = 0x10;                                      
  /* ### Init_GPIO init code */
  /* PTBD: PTBD4=1 */
  PTBD |= (unsigned char)0x10;                      
  /* PTBPE: PTBPE4=0 */
  PTBPE &= (unsigned char)~0x10;                     
  /* PTBDD: PTBDD4=1 */
  PTBDD |= (unsigned char)0x10;                      
  /* ### Init_RTC init code */
  /* RTCMOD: RTCMOD=0x4F */
  RTCMOD = 0x4F;                       /* Set modulo register */
  /* RTCSC: RTIF=1,RTCLKS=1,RTIE=1,RTCPS=0x0D */
  RTCSC = 0xBD;                        /* Configure RTC */
  /* ### */
  asm CLI;                             /* Enable interrupts */
} /*MCU_init*/


/*
** ===================================================================
**     Interrupt handler : isrVrtc
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVrtc(void)
{
  /* Write your interrupt code here ... */
  static char test = 0;
  RTCSC_RTIF = 1;
  test = 1 - test;
  PTBD_PTBD4 = test;
}
/* end of isrVrtc */



/* Initialization of the CPU registers in FLASH */

/* CHECKSUMBYPASS: BIT=0xAA */
const unsigned char CHECKSUMBYPASS_INIT @0x0000FFBA = 0xAA;

/* NVPROT: FPS7=1,FPS6=1,FPS5=1,FPS4=1,FPS3=1,FPS2=1,FPS1=1,FPDIS=1 */
const unsigned char NVPROT_INIT @0x0000FFBD = 0xFF;

/* NVOPT: KEYEN=0,FNORED=1,SEC01=1,SEC00=0 */
const unsigned char NVOPT_INIT @0x0000FFBF = 0x7E;



extern near void _Startup(void);

/* Interrupt vector table */
#ifndef UNASSIGNED_ISR
  #define UNASSIGNED_ISR ((void(*near const)(void)) 0xFFFF) /* unassigned interrupt service routine */
#endif

void (* near const _vect[])(void) @0xFFC4 = { /* Interrupt vector table */
         isrVrtc,                      /* Int.no. 29 Vrtc (at FFC4)                  Used */
         UNASSIGNED_ISR,               /* Int.no. 28 VReserved28 (at FFC6)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 27 VReserved27 (at FFC8)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 26 Vmtim (at FFCA)                 Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 25 Vkeyboard (at FFCC)             Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 24 VReserved24 (at FFCE)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 23 VReserved23 (at FFD0)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 22 VReserved22 (at FFD2)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 21 Vscitx (at FFD4)                Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 20 Vscirx (at FFD6)                Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 19 Vscierr (at FFD8)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 18 VReserved18 (at FFDA)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 17 VReserved17 (at FFDC)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 16 VReserved16 (at FFDE)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 15 VReserved15 (at FFE0)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 14 VReserved14 (at FFE2)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 13 VReserved13 (at FFE4)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 12 VReserved12 (at FFE6)           Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 11 Vtpmovf (at FFE8)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 10 Vtpmch1 (at FFEA)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  9 Vtpmch0 (at FFEC)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  8 VReserved8 (at FFEE)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  7 Vusb (at FFF0)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  6 VReserved6 (at FFF2)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  5 Vspi (at FFF4)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  4 Vlol (at FFF6)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  3 Vlvd (at FFF8)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  2 Virq (at FFFA)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  1 Vswi (at FFFC)                  Unassigned */
         _Startup                      /* Int.no.  0 Vreset (at FFFE)                Reset vector */
};




/* END MCUinit */

/*
** ###################################################################
**
**     This file was created by Processor Expert 3.07 [04.34]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
